############################################################################
########################	   function define       #######################
############################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

library(amap)
error.bar <- function(x, y, upper, lower=upper, length=0.1,...){
  if(length(x) != length(y) | length(y) !=length(lower) | length(lower) != length(upper))
    stop("vectors must be same length")
  arrows(x,y+upper, x, y-lower, angle=90, code=3, length=length, ...)
}


NaivePrimedGeneBarplot <- function(genes){
	for(each in genes){
		plot_matrix <- as.matrix(rbind(pData[each,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")],nData[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]))
		ymax <- max(plot_matrix)
		plot_sd <- rbind(c(0,0,0,0,0,0,0,0,0),n_log_sd[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")])
		bp <- barplot(plot_matrix,beside=T,col=c(cccol[2],cccol[1]),main=each,ylab="log2(fpkm+1)",names.arg=common_time_point,las=2,bty="l",border = NA,ylim=c(0,ymax*1.3))
		n <- c(2,2,2,2,2,2,2,2,2)
		error.bar(bp,plot_matrix, 1.96 * plot_sd / sqrt(n),col="black",length=0.02,lwd=1)
		legend("topleft",c("naive","primed"),col=c(cccol[1],cccol[2]),pch=15,bty="n")

		plot_matrix <- as.matrix(rbind(pData2ndfpkm[each,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")],nData2ndfpkm[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]))
		ymax <- max(plot_matrix)
		plot_sd <- rbind(c(0,0,0,0,0,0,0,0,0),n_sd[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")])
		bp <- barplot(plot_matrix,beside=T,col=c(cccol[2],cccol[1]),main=each,ylab="fpkm",names.arg=common_time_point,las=2,bty="l",border = NA,ylim=c(0,ymax*1.3))
		n <- c(2,2,2,2,2,2,2,2,2)
		error.bar(bp,plot_matrix, 1.96 * plot_sd / sqrt(n),col="black",length=0.02,lwd=1)
		legend("topleft",c("naive","primed"),col=c(cccol[1],cccol[2]),pch=15,bty="n")

	}
}
############################################################################
#########################	   read in data       ##########################
############################################################################

############ 2nd naive RNAseq
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n12_r1","n12_r2","n14_r1","n14_r2","n20_r1","n20_r2","n24m_r1","n24m_r2","n24p_r1","n24p_r2","niPS_r1","niPS_r2")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1

n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24p","n24m","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:10],1,mean),apply(nfpkm2nd[,11:12],1,mean),apply(nfpkm2nd[,13:14],1,mean),apply(nfpkm2nd[,15:16],1,mean),apply(nfpkm2nd[,17:18],1,mean),apply(nfpkm2nd[,19:20],1,mean),apply(nfpkm2nd[,21:22],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)

############ 2nd primed RNAseq
pData2ndfpkm <- read.table("../data/paper.primed.fpkm.txt",header=T,row.names=1)

nData <- log2(nData2ndfpkm+1)
pData <- log2(pData2ndfpkm+1)
common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","iPSC-T")
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)

############################################################################
#########################	         plot         ##########################
############################################################################
methylated_gene <- c("TET1","TET2","TET3","DNMT1","DNMT3A","DNMT3B")

pdf("SFig5D.pdf",width=4.5,height=3.4)
cols <- cccol[0:length(methylated_gene)]
names(cols) <- methylated_gene
for (each in methylated_gene){
	xmax <- length(common_time_point)
	ymax <- 1.1 * max(c(20,as.numeric(nData2ndfpkm[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]),as.numeric(pData2ndfpkm[each,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")])))
	plot(1,type="n",ylim=c(0,ymax),xlim=c(1,length(common_time_point)),ylab="fpkm",xlab="",xaxt="n",main=each)
	axis(1,at=seq(xmax),labels=common_time_point,las=2)
	points(seq(length(common_time_point)),nData2ndfpkm[each,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")],lwd=3,type="l",col=cols[each],lty=1)
	points(seq(length(common_time_point)),pData2ndfpkm[each,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")],lwd=3,type="l",col=cols[each],lty=2)
	legend("topleft",c("naive","primed"),col=c(cols[each],cols[each]),lty=c(1,2),lwd=3,bty="n")
}
dev.off()